
!"Pocket Smalltalk fileout - 2002N108-0:27:36

/*
*
* Copyright (c) 2003 Ryuichi Sakamoto. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following condition met:
*
* 1. Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer as
* the first lines of this file unmodified.
* 2. Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in the
* documentation and/or other materials provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY Ryuichi Sakamoto ``AS IS'' AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL Ryuichi Sakamoto BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
* NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
* THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/"!

Object subclass: #CDBPointer
	instanceVariableNames: 'pointer offset isHandle'
	classVariableNames: ''!

Label subclass: #VariableLabel
	instanceVariableNames: 'labelPtr'
	classVariableNames: ''!

!CDBPointer methodsFor: 'predicates'!

isNull
	^pointer isNil ifTrue: [ true ] ifFalse: [ pointer isNull ].
! !


!CDBPointer methodsFor: 'comparing'!

= x
	^pointer = (x pointer).!

asInteger
	^pointer asInteger.! !


!CDBPointer methodsFor: 'initialization'!

initialize
	super initialize.
	isHandle := true.
	pointer := nil.
	offset := 0.! !


!CDBPointer methodsFor: 'memory management'!

handleSize
	^pointer handleSize.!

isHandle
	^isHandle.!

lock
	^pointer isNull ifTrue: [ nil ]
	ifFalse: [ CDBPointer pointer: pointer lock ].
!

pointerSize
	^pointer pointerSize.!

size
	^self isNull ifTrue: [ 0 ]
	ifFalse: [
		isHandle ifTrue: [ pointer handleSize ]
		ifFalse: [ pointer pointerSize ]
	].
	!

unlock
	pointer isNil ifFalse: [ pointer unlock ].
	^self.!

value
	^pointer.!

lock: block
	block value: self lock.
	self unlock.
	^self.! !


!CDBPointer methodsFor: 'uncategorized'!

reallyCopyToHeap: bytes length: size
	SYSTRAP DmWrite: pointer offset: offset from: bytes bytes: size.
	^self.
! !


!CDBPointer methodsFor: 'converting'!

extractCString
	^(pointer offsetBy: offset) extractCString.! !


!CDBPointer methodsFor: 'accessing'!

byteAt: off
	^pointer byteAt: (off + offset).!

byteAt: off put: val
	PadBuffer byteAt: 0 put: val.
	SYSTRAP DmWrite: pointer offset: (off + offset) from: PadBuffer bytes: 1.
!

dwordAt: off
	^pointer dwordAt: (off + offset).!

dwordAt: off put: val
	PadBuffer dwordAt: 0 put: val.
	SYSTRAP DmWrite: pointer offset: (off + offset) from: PadBuffer bytes: 4.!

offsetBy: newVal
	^(CDBPointer pointer: pointer) offset: newVal.!

offset
	^offset.!

stringAt: off
	^(pointer offsetBy: off + offset) extractCString!

stringAt: off put: val
	| ptr |
	ptr := val copyToHeap.
	SYSTRAP DmWrite: pointer offset: (off + offset) from: ptr bytes: ptr pointerSize.
	ptr free.!

wordAt: off
	^pointer wordAt: (off + offset).!

wordAt: off put: val
	PadBuffer wordAt: 0 put: val.
	SYSTRAP DmWrite: pointer offset: (off + offset) from: PadBuffer bytes: 2.! !


!CDBPointer methodsFor: 'private'!

isHandle: newVal
	isHandle := newVal.!

offset: newVal
	offset := newVal.!

value: newVal
	pointer := newVal.! !


!CDBPointer class methodsFor: 'uncategorized'!

handle: newHandle
	^(self new value: newHandle) isHandle: true.!

pointer: newPointer
	^(self new value: newPointer) isHandle: false.
! !


!CDBPointer class methodsFor: 'instance creation'!

new: size
	^self shouldNotImplement.!

new
	^super new initialize.! !


!VariableLabel methodsFor: 'initialization'!

initialize
	super initialize.
	labelPtr := nil.!

releaseDynamicMemory
	labelPtr isNil ifFalse: [
		labelPtr free.
	].! !


!VariableLabel methodsFor: 'accessing'!

label: string
	| formPtr stringPtr |
	formPtr := Form activeFormPointer.
	stringPtr := string copyToHeap.
	SYSTRAP FrmHideObject: formPtr index: self index.
	SYSTRAP CtlSetLabel: (self pointer) newLabel: stringPtr.
	SYSTRAP FrmShowObject: formPtr index: self index.
	labelPtr isNil ifFalse: [
		labelPtr free.
	].
	labelPtr := stringPtr.! !


!PalmOS class methodsFor: 'uncategorized'!

playSound: freq time: msec volume: vol
	PadBuffer
		byteAt: 0 put: 1;
		dwordAt: 2 put: freq;
		wordAt: 6 put: msec;
		wordAt: 8 put: vol.
	SYSTRAP SndDoCmd: (CPointer null) with: PadBuffer with: (0 bitShift: 8).
! !


!Date methodsFor: 'comparing'!

= date
	^(((self day)==(date day))&((self month)==(date month))&((self year)==(date year))).! !


!CPointer methodsFor: 'memory management'!

lock: block
	block value: (self lock).
	self unlock.! !


!CPointer methodsFor: 'accessing'!

stringAt: off
	^(self offsetBy: off) extractString.! !


!CPointer methodsFor: 'accessing'!

stringAt: off put: val
	val copyToHeap: (self offsetBy: off).
	! !


!CPointer methodsFor: 'uncategorized'!

reallyCopyToHeap: bytes length: size
	SYSTRAP MemMove: self from: bytes length: size.
	^self.
! !


!String methodsFor: 'copying'!

copyToHeap: pointer
	pointer reallyCopyToHeap: self length: self basicSize.
	pointer byteAt: self basicSize put: 0.
	^pointer.! !


!ByteArray methodsFor: 'copying'!

copyToHeap: pointer
	^pointer reallyCopyToHeap: self length: self basicSize.
! !


